% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pvo.R
\encoding{UTF-8}
\name{plot_pvo}
\alias{plot_pvo}
\title{Plots estimates of species traits distribution}
\usage{
plot_pvo(phy, traits, map = NULL, mcmc.log, tip = NA, burnin = 0.1,
  conf = 0.95, stat = "median", trait.lab = "x", col = NULL,
  lab = TRUE, lolipop = c(0.4, 0.4), cex.tip = par("cex"),
  var.f = NULL, ...)
}
\arguments{
\item{phy}{phylogenetic tree provided as either a simmap or a phylo object}

\item{traits}{trait data used to perform the jive analysis. This has to be of the same form as the one used in \code{\link{make_jive}}}

\item{map}{map used to perform the jive analysis. This has to be of the same form as the one used in \code{\link{make_jive}}}

\item{mcmc.log}{the output file of a \code{\link{mcmc_bite}} run}

\item{tip}{A string giving the species to be plotted. If tip == NA, the posterior distribution of every tip is plotted along with the phylogenetic tree}

\item{burnin}{The size of the burnin in number of iterations or the proportion of iteration you want to remove}

\item{conf}{A number of [0,1] giving the confidence level desired.}

\item{stat}{A character giving the function to be used to estimate species mean and variance from the posterior distributions. Must be one of be "mean" and "median"}

\item{trait.lab}{a charachter specifying the axis label for the traits}

\item{col}{color of the density filling. Must be of size two for estimates and HPD. If col and border are NULL, two random colors are assigned}

\item{lab}{logical indicating whether to show species name in the plot. Only evaluated if tip =! NA}

\item{lolipop}{size and width of the lolipops representing samples}

\item{cex.tip}{size of the tips}

\item{var.f}{alternative distribution used to model intraspecific variation of the form function(n, pars). The function must return n samples from the given distribution.}

\item{...}{Additional parameters that can be parsed to plot}
}
\description{
Density plot representing estimated species trait distributions under a jive model.
This function plots the mean or median density distribution and the HPD distributions assuming that the trait is normally distributed
}
\examples{
## Load test data
data(Anolis_traits)
data(Anolis_tree)
data(Anolis_map)
# Run a simple MCMC chain
my.jive <- make_jive(Anolis_tree, Anolis_traits[,-3],  model.priors=list(mean="BM", logvar = "OU"))
bite_ex <- tempdir()
logfile <- sprintf("\%s/my.jive_mcmc.log", bite_ex)
mcmc_bite(my.jive, log.file=logfile, sampling.freq=1, print.freq=1, ngen=500) 
# import the results in R
res <- read.csv(logfile, header = TRUE, sep = "\\t")
 plot_pvo(phy = Anolis_tree, traits = Anolis_traits, tip = NA, mcmc.log = res)

}
\author{
Theo Gaboriau
}
