% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobians.R
\name{jac.exp}
\alias{jac.exp}
\title{Jacobian for exponential transform}
\usage{
jac.exp(x, log = TRUE)
}
\arguments{
\item{x}{value at which to evaluate \eqn{J(x)}}

\item{log}{TRUE to return \eqn{log(J(x))}}
}
\description{
Let \eqn{X=exp(Y)} be a transformation of a random variable \eqn{Y}.  
This function computes the jacobian \eqn{J(x)} when using the density of 
\eqn{Y} to evaluate the density of \eqn{X} via
\deqn{f(x) = f_y(ln(x)) J(x)}
where 
\deqn{J(x) = d/dx ln(x).}
}
\examples{
jac.exp(1)

}
