% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp_data.R
\name{simulate_birp}
\alias{simulate_birp}
\title{This function simulates a birp_data object for tidy data}
\usage{
simulate_birp(
  timepoints = c(1, 2, 3),
  timesOfChange = c(),
  gamma = NULL,
  negativeBinomial = FALSE,
  stochastic = FALSE,
  numLocations = 2,
  numMethods = 1,
  numCIGroups = 1,
  numCovariatesEffort = 1,
  numCovariatesDetection = 0,
  BACI = NULL,
  n_bar = 1000,
  N_0 = NULL,
  a = NULL,
  logSigma = NULL,
  logPhi = NULL,
  covariatesEffort = "gamma(1, 2)",
  covariatesDetection = "normal(0, 1)",
  proportionZeroEffort = 0,
  verbose = TRUE
)
}
\arguments{
\item{timepoints}{A vector of integers that denote the time points}

\item{timesOfChange}{A numeric or integer vector specifying the times of change}

\item{gamma}{A numeric vector denoting the values of gamma to simulate. If NULL, all gamma will be set to zero}

\item{negativeBinomial}{A boolean indicating if the Poisson (default) or negative binomial model should be used}

\item{stochastic}{A boolean indicating if the deterministic (default) or stochastic trend model should be used}

\item{numLocations}{An integer denoting the number of locations}

\item{numMethods}{An integer denoting the number of methods}

\item{numCIGroups}{An integer denoting the number of control-intervention (CI) groups}

\item{numCovariatesEffort}{An integer denoting the number of covariates for modeling the effort}

\item{numCovariatesDetection}{An integer denoting the number of covariates for modeling the detection probabilities}

\item{BACI}{A matrix specifying the BACI configuration. Each row of the matrix corresponds to a control/intervention group, and each column to an epoch. In addition, the very first column specifies the name of the control-intervention group. The values of the matrix specify which gamma to use for each group and epoch. E.g. BACI = matrix(c("A", "B", 1, 1, 1, 2), nrow = 2) corresponds to a canonical BACI design where the first row represents the control group (A) and the second row represents the intervention group (B)}

\item{n_bar}{A numeric value denoting the average number of counts to be simulated}

\item{N_0}{A numeric value denoting the expected number of observations at the first time point. If NULL, n_bar will be used instead}

\item{a}{A single value (shared across methods) or a numeric vector (per method) used to simulate values under the negative binomial distribution}

\item{logSigma}{A single value denoting the value of logSigma of the stochastic model to simulate. If NULL, logSigma will be set to -1}

\item{logPhi}{A numeric vector denoting the values of logPhi of the stochastic model to simulate. If NULL, logPhi will be simulated according to the model assumptions}

\item{covariatesEffort}{Denotes the covariates for calculating the effort. There are 3 options: 1) a single number, which is used for all covariates and locations; 2) a vector of numbers, one per covariate but the same for all location; 3) a distribution to simulate the effort from, which can be either "gamma(a, b)" or "uniform(a, b)" where a and b can be set or 4) a vector of such distributions, one per covariate}

\item{covariatesDetection}{Denotes the covariates for calculating the detection probabilities. There are 3 options: 1) a single number, which is used for all covariates and locations; 2) a vector of numbers, one per covariate but the same for all location; 3) a distribution to simulate the detection probabilities from, which can be either "normal(a, b)" or "uniform(a, b)" where a and b can be set or 4) a vector of such distributions, one per covariate}

\item{proportionZeroEffort}{The proportion of effort covariates which are set to zero}

\item{verbose}{Logical. If \code{FALSE}, the console output is suppressed}
}
\value{
An object of type \link{birp_data}
}
\description{
This function simulates a birp_data object for tidy data
}
\examples{
data <- simulate_birp()
}
