% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp_data.R
\name{birp_data}
\alias{birp_data}
\title{Creating a Birp Data Object based on counts and efforts for a single method}
\usage{
birp_data(counts, efforts, times, CI_groups = NULL, location_names = NULL)
}
\arguments{
\item{counts}{An J x K matrix of the observed counts. Each of the J rows corresponds to a location obtained at each of K times (columns)}

\item{efforts}{An J x K matrix of the effort conducted to observe the counts}

\item{times}{A vector giving the K time points at which counts were obtained}

\item{CI_groups}{The name of the control-intervention (CI) group for each location. By default, all locations belong to the same group (group_1)}

\item{location_names}{Names to distinguish the locations. By default, locations are named after their row index in counts}
}
\value{
An object of type birp_data
}
\description{
This function creates a birp_data object
}
\examples{
data <- birp_data(c(10,20,30), c(100,200,300), c(1,2,5))
}
