% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/words.R
\name{related_words}
\alias{related_words}
\title{Retrieve related words}
\usage{
related_words(key, words, use_canonical = FALSE, ...)
}
\arguments{
\item{key}{a Wordnik API key. These can be obtained
at the \href{http://developer.wordnik.com/}{Wordnik developer portal}.}

\item{words}{a vector of words.}

\item{use_canonical}{whether to use the stemmed, canonical form of the word
(i.e. 'cat', for 'cats') instead of the actual \code{word}. FALSE by default.
Note that for pronunciations specifically, setting it to TRUE may get a wider
range of pronunciations; you should experiment.}

\item{...}{further arguments to pass to httr's GET.}
}
\value{
a data.frame of 3 columns: \code{word} (the original term),
\code{type} (the type of relationship) and \code{related_word}.
}
\description{
\code{related_words} grabs terms that are in some way associated
with the \code{words} argument.
}
\examples{
\dontrun{
cat_adjacent <- related_words(key = "madeupkey", words = "cat")
}
}
