% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_PAM_CS.R
\name{prepare_PAM_CS}
\alias{prepare_PAM_CS}
\title{Preparing data for new range-diversity plot}
\usage{
prepare_PAM_CS(PAM, exclude_column = NULL, id_column = NULL,
               significance_test = FALSE, randomization_iterations = 100,
               CL = 0.05, picante_iterations = NULL,
               keep_randomizations = FALSE, parallel = FALSE,
               n_cores = NULL)
}
\arguments{
\item{PAM}{matrix, data.frame, or base_PAM object containing information on
presence and absence of species for a set of sites. Sites are organized in
the rows and species in the columns. See details.}

\item{exclude_column}{(optional) name or numeric index of columns to be
excluded. Default = NULL.}

\item{id_column}{(optional) name or numeric index of column containing the
ID of sites (cells of the PAM). Default = NULL.}

\item{significance_test}{(logical) whether to perform a test to detect
sites (cells) that are statistically significant (i.e., the pattern detected
can be distinguished from random expectations). Default = FALSE.}

\item{randomization_iterations}{(numeric) number of iterations for the
randomization test used to calculate statistical significance. Default = 100.}

\item{CL}{(numeric) confidence limit to detect statistically significant
values. Default = 0.05.}

\item{picante_iterations}{(numeric) number of iterations to be used for each
matrix randomization process (to be done \code{randomization_iterations}
times). This process is done using the function \code{randomizeMatrix}
from the package \code{picante}. The default, NULL, uses \code{2 * sum(PAM)}.}

\item{keep_randomizations}{(logical) whether to keep a matrix with all values
from the randomization process. Default = FALSE.}

\item{parallel}{(logical) whether to perform analyses in parallel.
Default = FALSE.}

\item{n_cores}{(numeric) number of cores to be used when \code{parallel} =
TRUE. The default, NULL, uses available cores - 1.}
}
\value{
An S3 object of class \code{\link{PAM_CS}} if \code{PAM} is a matrix or
data.frame, otherwise, an object of class \code{\link{base_PAM}} that
contains the \code{\link{PAM_CS}} object as a part of \code{PAM_indices}.

Significant values are presented as a vector in which 0 means
non-significant, and 1 and 2 represent significant values below and above
confidence limits of random expectations, respectively.
}
\description{
Preparation of data and details to create range-diversity
plots.
}
\details{
Range-diversity plot allow explorations of patterns of biodiversity
in a region based on the data of presence-absence matrices. The
plots to be produced using the information prepared here are a modification
of those presented in Arita et al. (2011)
\doi{https://doi.org/10.1111/j.1466-8238.2011.00662.x}.
}
\examples{
# Data
data("b_pam", package = "biosurvey")

# Preparing data for CS diagram
pcs <- prepare_PAM_CS(PAM = b_pam)

summary(pcs$PAM_indices$CS_diagram)
}
