% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhclu_clara.R
\name{nhclu_clara}
\alias{nhclu_clara}
\title{Non hierarchical clustering: CLARA}
\usage{
nhclu_clara(
  dissimilarity,
  index = names(dissimilarity)[3],
  seed = NULL,
  n_clust = c(1, 2, 3),
  maxiter = 0,
  initializer = "LAB",
  fasttol = 1,
  numsamples = 5,
  sampling = 0.25,
  independent = FALSE,
  algorithm_in_output = TRUE
)
}
\arguments{
\item{dissimilarity}{the output object from \code{\link[=dissimilarity]{dissimilarity()}} or
\code{\link[=similarity_to_dissimilarity]{similarity_to_dissimilarity()}}, or a \code{dist} object. If a \code{data.frame} is
used, the first two columns represent pairs of sites (or any pair of nodes),
and the next column(s) are the dissimilarity indices.}

\item{index}{name or number of the dissimilarity column to use. By default,
the third column name of \code{dissimilarity} is used.}

\item{seed}{for the random number generator (NULL for random by default).}

\item{n_clust}{an \code{integer} or an \code{integer} vector specifying the
requested number(s) of clusters.}

\item{maxiter}{an \code{integer} defining the maximum number of iterations.}

\item{initializer}{a \code{character}, either 'BUILD' (used in classic PAM
algorithm) or 'LAB' (linear approximative BUILD).}

\item{fasttol}{positive \code{numeric} defining the tolerance for fast swapping
behavior, set to 1 by default.}

\item{numsamples}{positive \code{integer} defining the number of samples to draw.}

\item{sampling}{positive \code{numeric} defining the sampling rate.}

\item{independent}{a \code{boolean} indicating that the previous
medoids are not kept in the next sample (FALSE by default).}

\item{algorithm_in_output}{a \code{boolean} indicating if the original output
of \link[fastkmedoids:fastclara]{fastclara} should be returned in the output
(\code{TRUE} by default, see Value).}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five slots:
\enumerate{
\item{\strong{name}: \code{character} containing the name of the algorithm}
\item{\strong{args}: \code{list} of input arguments as provided by the user}
\item{\strong{inputs}: \code{list} of characteristics of the clustering process}
\item{\strong{algorithm}: \code{list} of all objects associated with the
clustering procedure, such as original cluster objects (only if
\code{algorithm_in_output = TRUE})}
\item{\strong{clusters}: \code{data.frame} containing the clustering results}}

In the \code{algorithm} slot, if \code{algorithm_in_output = TRUE}, users can
find the output of
\link[fastkmedoids:fastclara]{fastclara}.
}
\description{
This function performs non hierarchical clustering on the basis of
dissimilarity with partitioning around medoids, using the Clustering Large
Applications (CLARA) algorithm.
}
\details{
Based on \href{https://cran.r-project.org/package=fastkmedoids}{fastkmedoids}
package (\link[fastkmedoids:fastclara]{fastclara}).
}
\examples{
comat <- matrix(sample(0:1000, size = 500, replace = TRUE, prob = 1/1:1001),
20, 25)
rownames(comat) <- paste0("Site",1:20)
colnames(comat) <- paste0("Species",1:25)

dissim <- dissimilarity(comat, metric = "all")

clust1 <- nhclu_clara(dissim, index = "Simpson", n_clust = 5)

partition_metrics(clust1, dissimilarity = dissim,
eval_metric = "pc_distance")

   
}
\references{
\insertRef{Schubert2019}{bioregion}
}
\seealso{
\link{nhclu_pam}
}
\author{
Pierre Denelle (\email{pierre.denelle@gmail.com}),
Boris Leroy (\email{leroy.boris@gmail.com}), and
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
