% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_4.R
\name{predict2.bm}
\alias{predict2.bm}
\alias{predict2}
\alias{predict2.biomod2_model.RasterStack}
\alias{predict2.biomod2_model.data.frame}
\alias{predict2.ANN_biomod2_model.RasterStack}
\alias{predict2.ANN_biomod2_model.data.frame}
\alias{predict2.CTA_biomod2_model.RasterStack}
\alias{predict2.CTA_biomod2_model.data.frame}
\alias{predict2.FDA_biomod2_model.RasterStack}
\alias{predict2.FDA_biomod2_model.data.frame}
\alias{predict2.GAM_biomod2_model.RasterStack}
\alias{predict2.GAM_biomod2_model.data.frame}
\alias{predict2.GBM_biomod2_model.RasterStack}
\alias{predict2.GBM_biomod2_model.data.frame}
\alias{predict2.GLM_biomod2_model.RasterStack}
\alias{predict2.GLM_biomod2_model.data.frame}
\alias{predict2.MARS_biomod2_model.RasterStack}
\alias{predict2.MARS_biomod2_model.data.frame}
\alias{predict2.MAXENT.Phillips_biomod2_model.data.frame}
\alias{predict2.MAXENT.Phillips.2_biomod2_model.RasterStack}
\alias{predict2.MAXENT.Phillips.2_biomod2_model.data.frame}
\alias{predict2.RF_biomod2_model.RasterStack}
\alias{predict2.RF_biomod2_model.data.frame}
\alias{predict2.SRE_biomod2_model.RasterStack}
\alias{predict2.SRE_biomod2_model.data.frame}
\alias{predict2,biomod2_model,RasterStack-method}
\alias{predict2,biomod2_model,data.frame-method}
\alias{predict2,ANN_biomod2_model,RasterStack-method}
\alias{predict2,ANN_biomod2_model,data.frame-method}
\alias{predict2,CTA_biomod2_model,RasterStack-method}
\alias{predict2,CTA_biomod2_model,data.frame-method}
\alias{predict2,FDA_biomod2_model,RasterStack-method}
\alias{predict2,FDA_biomod2_model,data.frame-method}
\alias{predict2,GAM_biomod2_model,RasterStack-method}
\alias{predict2,GAM_biomod2_model,data.frame-method}
\alias{predict2,GBM_biomod2_model,RasterStack-method}
\alias{predict2,GBM_biomod2_model,data.frame-method}
\alias{predict2,GLM_biomod2_model,RasterStack-method}
\alias{predict2,GLM_biomod2_model,data.frame-method}
\alias{predict2,MARS_biomod2_model,RasterStack-method}
\alias{predict2,MARS_biomod2_model,data.frame-method}
\alias{predict2,MAXENT.Phillips_biomod2_model,RasterStack-method}
\alias{predict2,MAXENT.Phillips_biomod2_model,data.frame-method}
\alias{predict2,MAXENT.Phillips.2_biomod2_model,RasterStack-method}
\alias{predict2,MAXENT.Phillips.2_biomod2_model,data.frame-method}
\alias{predict2,RF_biomod2_model,RasterStack-method}
\alias{predict2,RF_biomod2_model,data.frame-method}
\alias{predict2,SRE_biomod2_model,RasterStack-method}
\alias{predict2,SRE_biomod2_model,data.frame-method}
\title{Functions to get predictions from \code{\link{biomod2_model}} objects}
\usage{
predict2(object, newdata, ...)

\S4method{predict2}{biomod2_model,RasterStack}(object, newdata, predfun, seedval = NULL, use_calc = FALSE, ...)

\S4method{predict2}{biomod2_model,data.frame}(object, newdata, predfun, seedval = NULL, ...)

\S4method{predict2}{ANN_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{ANN_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{CTA_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{CTA_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{FDA_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{FDA_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{GAM_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{GAM_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{GBM_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{GBM_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{GLM_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{GLM_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{MARS_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{MARS_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{MAXENT.Phillips_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{MAXENT.Phillips_biomod2_model,data.frame}(object, newdata, do_raster = FALSE, newraster = NULL, ...)

\S4method{predict2}{MAXENT.Phillips.2_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{MAXENT.Phillips.2_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{RF_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{RF_biomod2_model,data.frame}(object, newdata, ...)

\S4method{predict2}{SRE_biomod2_model,RasterStack}(object, newdata, ...)

\S4method{predict2}{SRE_biomod2_model,data.frame}(object, newdata, ...)
}
\arguments{
\item{object}{a \code{\link{biomod2_model}} object}

\item{newdata}{a \code{data.frame} or
\code{\link[raster:stack]{RasterStack}} object containing data for new
predictions}

\item{predfun}{a \code{function}, generated by the \code{predict2} method
  specific to each \code{\link{biomod2_model}} subclass and used within the
  generic \code{predict2.biomod2_model.RasterStack} or
\code{predict2.biomod2_model.data.frame} to do the prediction}

\item{seedval}{(\emph{optional, default} \code{NULL}) \cr An \code{integer}
value corresponding to the new seed value to be set}

\item{use_calc}{(\emph{optional, default} \code{FALSE}). A boolean used for
the \code{\link[raster:stack]{RasterStack}} methods, when
\code{\link[raster:predict]{predict.RasterStack}} 
cannot be used and \code{\link[raster:calc]{calc}} must be used instead.}

\item{do_raster}{(\emph{optional, default} \code{NULL}). A boolean used with
\code{MAXENT.Phillips}, so that the
\code{\link[raster:stack]{RasterStack}} method can use the
\code{data.frame} method.}

\item{newraster}{(\emph{optional, default} \code{NULL}). A
\code{\link[raster:raster]{raster}} used by the \code{MAXENT.Phillips}
method so that the  \code{data.frame} method can transform its results
back into \code{\link[raster:stack]{RasterStack}} when \code{do_raster =
TRUE}.}

\item{\ldots}{(\emph{optional)})}
}
\description{
Internal S4 method used to predict single models from 
\code{\link{biomod2_model}} on (new) explanatory variables. \code{predict2} 
was introduced to allow a signature with two arguments : \code{object}, 
a type of \code{\link{biomod2_model}} and \code{newdata}, either a
\code{\link[raster:stack]{RasterStack}} or a \code{data.frame}.
}
\seealso{
\code{\link{biomod2_model}}

Other Toolbox functions: 
\code{\link{getters.bm}},
\code{\link{getters.out}},
\code{\link{load_stored_object}()},
\code{\link{predict.bm}},
\code{\link{predict.em}},
\code{\link{predict2.em}}
}
\author{
Remi Patin
}
\concept{Toolbox functions}
\keyword{internal}
