% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_si.R
\name{calc_si}
\alias{calc_si}
\title{Compute similarity index}
\usage{
calc_si(a, b)
}
\arguments{
\item{a}{encoding (see \code{\link{validate_encoding}} for more information 
about the required structure of encoding).}

\item{b}{encoding to which \code{a} should be compared. Must have equal number 
of groups or less than \code{a}. Both \code{a} and {b} must have the the same 
number of elements.}
}
\value{
the value of similarity index.
}
\description{
Computes similarity index between two encodings.
}
\details{
Briefly, the similarity index is a fraction of elements that have 
the same pairing in both encodings. Pairing is a binary variable, that has 
value 1 if two elements are in the same group and 0 if not. For more details, 
see references.
}
\examples{
# example from Stephenson & Freeland, 2013 (Fig. 6)
enc1 <- list(`1` = "A",
             `2` = c("F", "E"),
             `3` = c("C", "D", "G"))

enc2 <- list(`1` = c("A", "G"),
             `2` = c("C", "D", "E", "F"))

enc3 <- list(`1` = c("D", "G"),
             `2` = c("E", "F"),
             `3` = c("A", "C"))
             
calc_si(enc1, enc2)
calc_si(enc2, enc3)
calc_si(enc1, enc3)
}
\references{
Stephenson, J.D., and Freeland, S.J. (2013). Unearthing the Root 
of Amino Acid Similarity. J Mol Evol 77, 159-169.
}
\seealso{
\code{\link{calc_ed}}: calculate the encoding distance between two encodings.
}

