% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert_json}
\alias{convert_json}
\title{Convert BioCompute Object or domain to JSON string}
\usage{
convert_json(x, pretty = TRUE, auto_unbox = TRUE, na = "string", ...)
}
\arguments{
\item{x}{BioCompute Object or domain}

\item{pretty}{Prettify the JSON string? Default is \code{TRUE}.}

\item{auto_unbox}{Unbox all atomic vectors of length 1? Default is \code{TRUE}.}

\item{na}{How to represent NA values: must be \code{"null"} or \code{"string"}.
Default is \code{"string"}.}

\item{...}{Additional parameters for \code{\link[jsonlite]{toJSON}}.}
}
\value{
JSON string of the BioCompute Object
}
\description{
Convert BioCompute Object or domain to JSON string
}
\examples{
compose_description() \%>\% convert_json()
generate_example("minimal") \%>\% convert_json()
}
