% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalue.R
\name{pvalue}
\alias{pvalue}
\title{t-Test on Summary Dataframe}
\usage{
pvalue (dataframe, control, sigval)
}
\arguments{
\item{dataframe}{a summary dataframe of \code{\link{dfsummary}} output}

\item{control}{control group name}

\item{sigval}{pvalue cutoff for significance}
}
\value{
A dataframe. New columns named 'pvalue' (p values of t-test.If the value is less than 0.001, then appear as "< 0.001") and 'significance' (yes if pvalue less than 'sigval') are attached to the left.
}
\description{
This function calculate the significance (t-test) within groups of 'dataframe'
}
\details{
The 'dataframe' should be having similar format of \code{\link{dfsummary}} output. 'control' should be an element from the column just before 'label'. 'N', 'Mean', 'SD' and 'CV' columns in the 'dataframe' are used for calculating p value by t-test (one to one t-test with 'control' in that group). significant if pvalue is < 'sigval'. Different groups in 'dataframe' are evaluated separately (columns before label is used for grouping).
}
\examples{
## loading data
data(metafile384, rawdata384)
rawdata<-plate2df(data2plateformat(rawdata384,platetype = 384))
data_DF2<- dplyr::inner_join(rawdata,metafile384,by=c("row","col","position"))
result3 <- dfsummary(data_DF2,y = "value",
                    grp_vector = c("cell","compound","concentration"),
                    rm_vector = c("B", "drug2", "huh7"),
                    nickname = "",
                    rm = "FALSE", param = c(strict = "FALSE", cutoff = 40,n = 12))

## eg:1 t-test on result3.
pvalue(result3,"C3",sigval=0.05)

}
\author{
A.A Palakkan
}
\keyword{htest}
