% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_audio.R
\name{read_wav}
\alias{read_wav}
\title{Read WAV files}
\usage{
read_wav(filename, time_exp = 1, from = NULL, to = NULL)
}
\arguments{
\item{filename}{a WAV file.}

\item{time_exp}{integer. Time expansion factor of the recording.
Set to 1 for real-time recording or above for time expanded recording. Default setting is 1.}

\item{from}{optional. Numeric. Where to start reading the recording, in seconds (s).}

\item{to}{optional. Numeric. Where to end reading the recording, in seconds (s).}
}
\value{
A \link[tuneR]{Wave} object.
}
\description{
A thin wrapped around \link[tuneR]{readWave} from the package tuneR.
}
\examples{
\donttest{
filepath <- system.file("extdata", "recording.wav", package = "bioacoustics")
read_wav(filepath)
}

}
