% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_into_vpts.R
\name{bind_into_vpts}
\alias{bind_into_vpts}
\alias{bind_into_vpts.vp}
\alias{bind_into_vpts.list}
\alias{bind_into_vpts.vpts}
\title{Bind vertical profiles (\code{vp}) into time series (\code{vpts})}
\usage{
bind_into_vpts(x, ...)

\method{bind_into_vpts}{vp}(...)

\method{bind_into_vpts}{list}(x, ...)

\method{bind_into_vpts}{vpts}(..., attributes_from = 1)
}
\arguments{
\item{x}{A \code{vp}, \code{vpts} object or a vector of these.}

\item{...}{A \code{vp}, \code{vpts} object or a vector of these.}

\item{attributes_from}{Integer. Which \code{vpts} to copy attributes from
(default: first).}
}
\value{
A \code{vpts} for a single radar or a list of \code{vpts} for multiple radars.
Input \code{vp} are sorted on datetime in the output \code{vpts}.
}
\description{
Binds vertical profiles (\code{vp}) into a vertical profile time series
(\code{vpts}), sorted on datetime. Can also bind multiple \code{vpts} of a
single radar into one \code{vpts}.
}
\details{
\code{bind_into_vpts()} currently requires profiles to have aligning altitude
layers that are of equal width. Profiles are allowed to differ in the number
of altitude layers, i.e. the maximum altitude.
}
\section{Methods (by class)}{
\itemize{
\item \code{bind_into_vpts(vp)}: Bind multiple \code{vp} into a \code{vpts}.
If \code{vp} for multiple radars are provided, a list is returned containing
a \code{vpts} for each radar.

\item \code{bind_into_vpts(list)}: Bind multiple \code{vp} objects into a
\code{vpts}. If data for multiple radars is provided, a list is returned
containing a \code{vpts} for each radar.

\item \code{bind_into_vpts(vpts)}: Bind multiple \code{vpts} into a single
\code{vpts}. Requires the input \code{vpts} to be from the same radar.

}}
\examples{
# Split the example vpts into two separate time series, one containing
# profile 1-10 and a second containing profile 11-20
vpts1 <- example_vpts[1:10]
vpts2 <- example_vpts[11:20]

# Bind the two vpts together
vpts1_and_2 <- bind_into_vpts(vpts1, vpts2)

# Verify that the binded vpts now has 20 profiles, 10 from vpts1 and 10 from
# vpts2
summary(vpts1_and_2)

# Extract two profiles
vp1 <- example_vpts[1]
vp1
vp2 <- example_vpts[2]
vp2

# Bind the two profiles back into a vpts:
bind_into_vpts(vp1, vp2)
}
\seealso{
\itemize{
\item \code{\link[=summary.vp]{summary.vp()}}
\item \code{\link[=summary.vpts]{summary.vpts()}}
}
}
