% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beam.R
\name{beam_range}
\alias{beam_range}
\title{Calculate radar beam range}
\usage{
beam_range(distance, elev, k = 4/3, lat = 35, re = 6378, rp = 6357)
}
\arguments{
\item{distance}{numeric. Distance from the radar as measured along sea level (down range) in m.}

\item{elev}{numeric. Beam elevation in degrees.}

\item{k}{Standard refraction coefficient.}

\item{lat}{Geodetic latitude of the radar in degrees.}

\item{re}{Earth equatorial radius in km.}

\item{rp}{Earth polar radius in km.}
}
\value{
numeric. Beam range (slant range) in m.
}
\description{
Calculates the range (i.e. slant range) given a distance measured along the earth's surface
(i.e. down range) and beam elevation.
}
\details{
depends on \link{beam_height} to calculate beam height.
}
\examples{
# slant range of the 5 degree elevation beam at a down range of 100 km:
beam_range(100000, 5)
}
