% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elevation_angles.R
\name{get_elevation_angles}
\alias{get_elevation_angles}
\alias{get_elevation_angles.pvol}
\alias{get_elevation_angles.scan}
\alias{get_elevation_angles.param}
\title{Get elevation angles of a polar volume (\code{pvol}), scan (\code{scan}) or parameter
(\code{param})}
\usage{
get_elevation_angles(x)

\method{get_elevation_angles}{pvol}(x)

\method{get_elevation_angles}{scan}(x)

\method{get_elevation_angles}{param}(x)
}
\arguments{
\item{x}{A \code{pvol}, \code{scan} or \code{param} object.}
}
\value{
The elevation angle(s) in degrees.
}
\description{
Returns the elevation angles in degrees of all scans within a polar volume
(\code{pvol}) or the elevation angle of a single scan (\code{scan}) or scan parameter
(\code{param}).
}
\examples{
# Locate and read the polar volume example file
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")
example_pvol <- read_pvolfile(pvolfile)

# Get the elevations angles of the scans in the pvol
get_elevation_angles(example_pvol)

# Extract the first scan
scan <- example_pvol$scans[[1]]

# Get the elevation angle of that scan
get_elevation_angles(scan)
}
\seealso{
\itemize{
\item \code{\link[=get_scan]{get_scan()}}
}
}
