% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan.R
\name{summary.scan}
\alias{summary.scan}
\alias{is.scan}
\alias{dim.scan}
\title{Inspect a scan (\code{scan})}
\usage{
\method{summary}{scan}(object, ...)

is.scan(x)

\method{dim}{scan}(x)
}
\arguments{
\item{object}{A \code{scan} object.}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{A \code{scan} object.}
}
\value{
For \code{\link[=is.scan]{is.scan()}}: \code{TRUE} for an object of class \code{scan}, otherwise
\code{FALSE}.

For \code{\link[=dim.scan]{dim.scan()}}: number of parameters (\code{param}), bins and rays in a
scan (\code{scan}).
}
\description{
R base functions for inspecting a scan (\code{scan}) object.
}
\details{
A scan (or sweep) is made by the radar at a certain elevation angle. The
resulting parameter data (\code{param}) are organized along radar range (bins) and
azimuth (rays). A scan (\code{scan}) object is a list containing:
\itemize{
\item \code{radar}: Radar identifier.
\item \code{datetime}: Nominal time of the volume to which the scan belongs in UTC.
\item \code{params}: List of scan parameters (\code{param}).
\item \code{attributes}: List of the scan's \code{what}, \code{where} and \code{how}
attributes.
\item \code{geo}: List of the scan's geographic properties:
\itemize{
\item \code{lat}: Latitude of the radar in decimal degrees.
\item \code{lon}: Longitude of the radar in decimal degrees.
\item \code{height}: Height of the radar antenna in meters above sea level.
\item \code{elange}: Elevation angle of the radar beam for that scan in degrees.
\item \code{rscale}: Range bin size for that scan in m (e.g. 500 m * 480 bins equals
240 km range).
\item \code{ascale}: Azimuth bin size for that scan in degrees (e.g. 1 degree * 360
rays equals full circle).
}
}
}
\examples{
# Load the example scan
scan <- example_scan

# Verify that it is an object of class scan
is.scan(scan)

# Get summary info
scan # Same as summary(scan) or print(scan)

# Get dimensions
dim(scan)

# Get summary info for the parameters in the scan
scan$params
}
\seealso{
\itemize{
\item \code{\link[=get_scan]{get_scan()}}
\item \code{\link{example_scan}}
\item \code{\link[=plot.scan]{plot.scan()}}
\item \code{\link[=get_param]{get_param()}}
}
}
