% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_vvp.R
\name{sd_vvp_threshold}
\alias{sd_vvp_threshold}
\alias{sd_vvp_threshold.vp}
\alias{sd_vvp_threshold.list}
\alias{sd_vvp_threshold.vpts}
\title{Get threshold of the VVP-retrieved radial velocity standard deviation}
\usage{
sd_vvp_threshold(x)

\method{sd_vvp_threshold}{vp}(x)

\method{sd_vvp_threshold}{list}(x)

\method{sd_vvp_threshold}{vpts}(x)
}
\arguments{
\item{x}{A \code{vp}, list of \code{vp} or \code{vpts} object.}
}
\value{
threshold for \code{sd_vvp} in m/s.
}
\description{
Gives the current threshold in VVP-retrieved radial velocity standard
deviation in m/s.
}
\details{
See also \link{sd_vvp_threshold<-} for setting an objects radial
velocity standard deviation.
}
\section{Methods (by class)}{
\itemize{
\item \code{vp}: threshold in VVP-retrieved radial velocity standard
deviation of a vertical profile

\item \code{list}: threshold in VVP-retrieved radial velocity standard
deviation of a list of vertical profiles

\item \code{vpts}: threshold in VVP-retrieved radial velocity standard
deviation of a time series of vertical profiles
}}

\examples{
# load example data:
data(example_vp)
data(example_vpts)

# retrieve threshold for a single vertical profile:
sd_vvp_threshold(example_vp)

# retrieve threshold for a vertical profile time series:
sd_vvp_threshold(example_vpts)

# change or set the threshold for a single vertical profile:
sd_vvp_threshold(example_vp) <- 2

# change or set the threshold for a vertical profile time series:
sd_vvp_threshold(example_vp) <- 2
}
