% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_convert.R
\name{scan_to_raster}
\alias{scan_to_raster}
\title{convert a polar scan into a raster}
\usage{
scan_to_raster(
  scan,
  nx = 100,
  ny = 100,
  xlim,
  ylim,
  res = NA,
  param,
  raster = NA,
  lat,
  lon,
  crs = NA,
  k = 4/3,
  re = 6378,
  rp = 6357
)
}
\arguments{
\item{scan}{a scan (sweep) of class scan}

\item{nx}{number of raster pixels in the x (longitude) dimension}

\item{ny}{number of raster pixels in the y (latitude) dimension}

\item{xlim}{x (longitude) range}

\item{ylim}{y (latitude) range}

\item{res}{numeric vector of length 1 or 2 to set the resolution of the raster (see \link[raster]{res}).
If this argument is used, arguments \code{nx} and \code{ny} are ignored. Unit is identical to \code{xlim} and \code{ylim}.}

\item{param}{scan parameters to include. If \code{NA} include all scan parameters. Reducing the number
of scan parameters speeds up evaluation.}

\item{raster}{(optional) RasterLayer with a CRS. When specified this raster topology is used for the output, and nx, ny, res
arguments are ignored.}

\item{lat}{Geodetic latitude of the radar in degrees. If missing taken from \code{scan}.}

\item{lon}{Geodetic longitude of the radar in degrees. If missing taken from \code{scan}.}

\item{crs}{character or object of class CRS. PROJ.4 type description of a Coordinate Reference System (map projection).
When 'NA' (default), an azimuthal equidistant projection with origin at the radar location is used.
To use a WSG84 (lat,lon) projection, use crs="+proj=longlat +datum=WGS84"}

\item{k}{Standard refraction coefficient.}

\item{re}{Earth equatorial radius in km.}

\item{rp}{Earth polar radius in km.}
}
\value{
a RasterBrick
}
\description{
convert an object of class 'scan' into a raster of class 'RasterBrick'
}
\details{
uses \link{scan_to_spatial} to georeference the scan's pixels. If multiple scan pixels fall within
the same raster pixel, the last added pixel is given (see \link[raster]{rasterize} for details).
}
\examples{
# default projects full extent on 100x100 pixel raster:
scan_to_raster(example_scan)

# crop the scan and project at a resolution of 0.1 degree:
scan_to_raster(example_scan, ylim = c(55, 57), xlim = c(12, 13), res = .1)

# using a template raster
template_raster <- raster::raster(raster::extent(12, 13, 56, 58), crs = sp::CRS("+proj=longlat"))
scan_to_raster(example_scan, raster = template_raster)
}
