% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan.R
\name{summary.scan}
\alias{summary.scan}
\alias{is.scan}
\alias{dim.scan}
\title{Class \code{scan}: a scan of a polar volume}
\usage{
\method{summary}{scan}(object, ...)

is.scan(x)

\method{dim}{scan}(x)
}
\arguments{
\item{object}{Object of class \code{scan}}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{Object of class \code{scan}}
}
\value{
For \code{is.scan}: \code{TRUE} if its argument is of
class \code{scan}.

For \code{dim.scan}: dimensions of the scan.
}
\description{
Class \code{scan} for a scan of a polar volume, and its associated R base functions.
}
\details{
A object of class \code{scan} is a list containing:
\describe{
 \item{\code{radar}}{character string with the radar identifier}
 \item{\code{datetime}}{nominal time of the volume to which this
   scan belongs [UTC]}
 \item{\code{params}}{a list with scan parameters}
 \item{\code{attributes}}{list with the scan's \code{\\what},
   \code{\\where} and \code{\\how} attributes}
 \item{\code{geo}}{geographic data, a list with:
    \describe{
     \item{\code{lat}}{latitude of the radar [decimal degrees]}
     \item{\code{lon}}{longitude of the radar [decimal degrees]}
     \item{\code{height}}{height of the radar
       antenna [meters above sea level]}
     \item{\code{elangle}}{radar beam elevation [degrees]}
     \item{\code{rscale}}{range bin size [m]}
     \item{\code{ascale}}{azimuth bin size [deg]}
    }
    The \code{geo} element of a \code{scan} object is a copy of the
    \code{geo} element of its parent polar volume of class \code{pvol}.
  }
}
}
\examples{
# load example scan object
data(example_scan)
# print the scan parameters contained in the scan:
example_scan$params
# extract the first scan parameter:
param <- example_scan$params[1]
is.scan("this is not a polar scan but a string") # > FALSE
}
