% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strain.R
\name{strain}
\alias{strain}
\title{Parse taxon or taxondf objects by a range of names}
\usage{
strain(.data, ...)
}
\arguments{
\item{.data}{Input, object of class taxon}

\item{...}{Logical predicates. Multiple conditions are combined with &.
See Details.}
}
\value{
A single or list of \code{taxon} class objects
}
\description{
Parse taxon or taxondf objects by a range of names
}
\details{
Example predicates:
\itemize{
 \item . > family = Get all taxa greater than family
 \item . < family = Get all taxa less than family
 \item . == family = Get all taxa equal to family
 \item . != family = Get all taxa not equal to family
 \item genus < order = Get all taxa between genus and order
 \item genus .. family = Get all taxa between genus and order
}
}
\examples{
# operating on `taxon` objects
out <- make_taxon(genus="Poa", epithet="annua", authority="L.",
   family='Poaceae', clazz='Poales', kingdom='Plantae', variety='annua')
out \%>\% strain(. < family)
out \%>\% strain(. < genus)
out \%>\% strain(. > family)
out \%>\% strain(. < family)
}
