% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick.R
\name{pick}
\alias{pick}
\title{Pick names}
\usage{
pick(.data, ...)
}
\arguments{
\item{.data}{Input, object of class taxon}

\item{...}{Further unnamed args, see examples}
}
\value{
For \code{taxon} inputs, gives back a \code{taxonref} object. For \code{taxondf}
inputs, gives back \code{taxondf}.
}
\description{
Pick names
}
\examples{
# operating on `taxon` objects
out <- make_taxon(genus="Poa", epithet="annua", authority="L.",
   family='Poaceae', clazz='Poales', kingdom='Plantae', variety='annua')
out \%>\% pick(family)
out \%>\% pick(genus)
out \%>\% pick(species, genus)
out \%>\% pick(species) \%>\% name()
out \%>\% pick(species) \%>\% uri()

# operating on taxonomic data.frames
df <- data.frame(class=c('Magnoliopsida','Magnoliopsida','Magnoliopsida',
                         'Magnoliopsida','Magnoliopsida','Magnoliopsida'),
         order=c('Asterales','Asterales','Fagales','Poales','Poales','Poales'),
         family=c('Asteraceae','Asteraceae','Fagaceae','Poaceae','Poaceae','Poaceae'),
         genus=c('Helianthus','Helianthus','Quercus','Poa','Festuca','Holodiscus'),
         stringsAsFactors = FALSE)
(df2 <- taxon_df(df))

## select single or many taxonomic classes
df2 \%>\% pick(order)
df2 \%>\% pick(family, genus)

# From taxa object
df2 \%>\% scatter \%>\% pick(family)
df2 \%>\% scatter \%>\% pick(family, species)
df2 \%>\% scatter \%>\% pick(family, species, genus)
}

