% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtReg.R
\name{coef.gtReg}
\alias{coef.gtReg}
\alias{coefficients.gtReg}
\title{Extract coefficients from a fitted group testing model}
\usage{
\method{coef}{gtReg}(object, digits = max(3, getOption("digits") - 3), ...)

\method{coefficients}{gtReg}(object, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{An object of class "gtReg", created by \code{\link{gtReg}},
from which the coefficients are to be extracted.}

\item{digits}{digits for rounding.}

\item{...}{not currently used.}
}
\value{
Model coefficients extracted from the object \kbd{object}.
}
\description{
Extract coefficients from objects of class "gtReg" returned
by \code{\link{gtReg}}.
}
\examples{
data(hivsurv)
fit1 <- gtReg(formula = groupres ~ AGE * EDUC.,
              data = hivsurv, groupn = gnum,
              linkf = "probit")
coefficients(object = fit1)
}
\author{
Brianna D. Hitt
}
