% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_utils.R
\name{bb_grid}
\alias{bb_grid}
\alias{bb_x_grid}
\alias{bb_y_grid}
\title{Grid property for a Billboard.js chart}
\usage{
bb_grid(bb, ...)

bb_x_grid(bb, ...)

bb_y_grid(bb, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{See \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.grid}}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Grid property for a Billboard.js chart
}
\note{
\code{bb_x_grid} and \code{bb_y_grid} are shortcut for modifying the x-axis and the y-axis respectively.
}
\examples{

stars <- data.frame(
  package = c("billboarder", "ggiraph", "officer", "shinyWidgets", "visNetwork"),
  stars = c(1, 176, 42, 40, 166)
)

billboarder() \%>\%
  bb_barchart(data = stars) \%>\% 
  bb_y_grid(show = TRUE)

billboarder() \%>\%
  bb_barchart(data = stars) \%>\% 
  bb_y_grid(lines = list(list(value = mean(stars$stars), text = "Horizontal line")))

}
