% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_MLBM_Binary_functions.R
\name{BIKM1_MLBM_Binary}
\alias{BIKM1_MLBM_Binary}
\title{BIKM1_MLBM_Binary fitting procedure}
\usage{
BIKM1_MLBM_Binary(x,y,Gmax,Hmax,Lmax,a=4,b=1,
Gstart=2,Hstart=2,Lstart=2,init_choice='smallVBayes',userparam=NULL,
ntry=50,criterion_choice='ICL', mc.cores=1,verbose=TRUE)
}
\arguments{
\item{x}{matrix of observations (1rst matrix).}

\item{y}{matrix of observations (2nd matrix).}

\item{Gmax}{a positive integer less than number of rows.}

\item{Hmax}{a positive integer less than number of columns of the 1st matrix.}

\item{Lmax}{a positive integer less than number of columns of the 2nd matrix. The bikm1 procedure stops while the numbers of rows is higher than Gmax or the number of columns is higher than Hmax or the numbers of columns(2nd matrix) is higher than Lmax.}

\item{a}{hyperparameter used in the VBayes algorithm for priors on the mixing proportions.
By default, a=4.}

\item{b}{hyperparameter used in the VBayes algorithm for prior on the Bernoulli parameter.
By default, b=1.}

\item{Gstart}{a positive integer to initialize the procedure with number of row clusters.
By default, Gstart=2.}

\item{Hstart}{a positive integer to initialize the procedure with number of column clusters.
By default, Hstart=2.}

\item{Lstart}{a positive integer to initialize the procedure with number of column clusters.
By default, Lstart=2.}

\item{init_choice}{character string corresponding to the chosen initialization strategy used for the procedure, which can be "random" or "smallVBayes" or "user".
By default, init_choice="smallVBayes".}

\item{userparam}{In the case where init_choice is "user", a list containing partitions z,v and w.}

\item{ntry}{a positive integer corresponding to the number of times which is launched the small VBayes initialization strategy. By default ntry=100.}

\item{criterion_choice}{Character string corresponding to the chosen criterion used for model selection, which can be "ICL" as for now.
By default, criterion_choice="ICL".}

\item{mc.cores}{a positive integer corresponding to the available number of cores for parallel computing.
By default, mc.cores=1.}

\item{verbose}{logical. To display each step and the result. By default verbose=TRUE.}
}
\value{
a BIKM1_MLBM_Binary object including

\code{model_max}: the selected model by the procedure including free energy W, theta, conditional probabilities (s_ig, r_jh,t_kl), iter, empty_cluster, and the selected partitions z,v and w.

\code{criterion_choice}: the chosen criterion

\code{init_choice}: the chosen init_choice

\code{criterion_tab}: matrix containing the criterion values for each selected number of row and column

\code{W_tab}: matrix containing the free energy values for each selected number of row and column

\code{criterion_max}: maximum of the criterion values

\code{gopt}: the selected number of rows

\code{hopt}: the selected number of columns (1rst matrix)

\code{lopt}: the selected number of columns (2nd matrix)
}
\description{
Produce a blockwise estimation of  double matrices of observations.
}
\examples{

require(bikm1)
set.seed(42)
n=200
J=120
K=120
g=3
h=2
l=2
theta=list()
theta$pi_g=1/g *matrix(1,g,1)
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$alpha_gh=matrix(runif(6),ncol=h)
theta$beta_gl=matrix(runif(6),ncol=l)
data=BinBlocRnd_MLBM(n,J,K,theta)
res=BIKM1_MLBM_Binary(data$x,data$y,3,2,2,Gstart=3,Hstart=2,Lstart=2,init_choice='user',
userparam=list(z=data$xrow,v=data$xcolx,w=data$xcoly))


}
\references{
Govaert and Nadif. Coclustering, Wyley (2013).

Keribin, Brault and Celeux. Estimation and Selection for the Latent Block Model on Categorical Data, Statistics and Computing (2014).

Robert. Classification crois\'ee pour l'analyse de bases de donn\'ees de grandes dimensions de pharmacovigilance. Paris Saclay (2017).
}
