% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varma.R
\name{sparseVARMA}
\alias{sparseVARMA}
\title{Sparse Estimation of the Vector AutoRegressive Moving Average (VARMA) Model}
\usage{
sparseVARMA(Y, U = NULL, VARp = NULL, VARpen = "HLag", VARlseq = NULL,
  VARgran = NULL, VARalpha = 0, VARMAp = NULL, VARMAq = NULL,
  VARMApen = "HLag", VARMAlPhiseq = NULL, VARMAPhigran = NULL,
  VARMAlThetaseq = NULL, VARMAThetagran = NULL, VARMAalpha = 0, h = 1,
  cvcut = 0.9, eps = 10^-3)
}
\arguments{
\item{Y}{A \eqn{T} by \eqn{k} matrix of time series. If k=1, a univariate autoregressive moving average model is estimated.}

\item{U}{A \eqn{T} by \eqn{k} matrix of (approximated) error terms. Typical usage is to have the program estimate a high-order VAR model (Phase I) to get approximated error terms U.}

\item{VARp}{User-specified maximum  autoregressive lag order of the PhaseI VAR. Typical usage is to have the program compute its own maximum lag order based on the time series length.}

\item{VARpen}{"HLag" (hierarchical sparse penalty) or "L1" (standard lasso penalty) penalization in PhaseI VAR.}

\item{VARlseq}{User-specified grid of values for regularization parameter in the PhaseI VAR. Typical usage is to have the program compute
its own grid. Supplying a grid of values overrides this. WARNING: use with care.}

\item{VARgran}{User-specified vector of granularity specifications for the penalty parameter grid of the PhaseI VAR:  First element specifies
how deep the grid should be constructed. Second element specifies how many values the grid should contain.}

\item{VARalpha}{a small positive regularization parameter value corresponding to squared Frobenius penalty in PhaseI VAR. The default is zero.}

\item{VARMAp}{User-specified maximum autoregressive lag order of the VARMA. Typical usage is to have the program compute its own maximum lag order based on the time series length.}

\item{VARMAq}{User-specified maximum moving average lag order of the VARMA. Typical usage is to have the program compute its own maximum lag order based on the time series length.}

\item{VARMApen}{"HLag" (hierarchical sparse penalty) or "L1" (standard lasso penalty) penalization in the VARMA.}

\item{VARMAlPhiseq}{User-specified grid of values for regularization parameter corresponding to the autoregressive coefficients in the VARMA. Typical usage is to have the program compute
its own grid. Supplying a grid of values overrides this. WARNING: use with care.}

\item{VARMAPhigran}{User-specified vector of granularity specifications for the penalty parameter grid corresponding to the autoregressive coefficients in the VARMA:  First element specifies
how deep the grid should be constructed. Second element specifies how many values the grid should contain.}

\item{VARMAlThetaseq}{User-specified grid of values for regularization parameter corresponding to the moving average coefficients in the VARMA. Typical usage is to have the program compute
its own grid. Supplying a grid of values overrides this. WARNING: use with care.}

\item{VARMAThetagran}{User-specified vector of granularity specifications for the penalty parameter grid corresponding to the moving average coefficients in the VARMA:  First element specifies
how deep the grid should be constructed. Second element specifies how many values the grid should contain.}

\item{VARMAalpha}{a small positive regularization parameter value corresponding to squared Frobenius penalty in  VARMA. The default is zero.}

\item{h}{Desired forecast horizon in time-series cross-validation procedure.}

\item{cvcut}{Proportion of observations used for model estimation in the time series cross-validation procedure. The remainder is used for forecast evaluation.}

\item{eps}{a small positive numeric value giving the tolerance for convergence in the proximal gradient algorithms.}
}
\value{
A list with the following components
\item{Y}{\eqn{T} by \eqn{k} matrix of time series.}
\item{U}{Matrix of (approximated) error terms.}
\item{k}{Number of time series.}
\item{VARp}{Maximum autoregressive lag order of the PhaseI VAR.}
\item{VARPhihat}{Matrix of estimated autoregressive coefficients of the Phase I VAR.}
\item{VARphi0hat}{Vector of Phase I VAR intercepts.}
\item{VARMAp}{Maximum autoregressive lag order of the VARMA.}
\item{VARMAq}{Maximum moving average lag order of the VARMA.}
\item{Phihat}{Matrix of estimated autoregressive coefficients of the VARMA.}
\item{Thetahat}{Matrix of estimated moving average coefficients of the VARMA.}
\item{phi0hat}{Vector of VARMA intercepts.}
}
\description{
Sparse Estimation of the Vector AutoRegressive Moving Average (VARMA) Model
}
\examples{
data(Y)
VARMAfit <- sparseVARMA(Y) # sparse VARMA
y <- matrix(Y[,1], ncol=1)
ARMAfit <- sparseVARMA(y) # sparse ARMA
}
\references{
Wilms Ines, Sumanta Basu, Bien Jacob and Matteson David S. (2017), "Sparse Identification and Estimation of High-Dimensional Vector AutoRegressive Moving Averages"
arXiv preprint <arXiv:1707.09208>.
}
\seealso{
\link{lagmatrix} and \link{directforecast}
}
