% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directforecast.R
\name{directforecast}
\alias{directforecast}
\title{Function to obtain h-step ahead direct forecast based on estimated VAR, VARX or VARMA model}
\usage{
directforecast(fit, model, h = 1)
}
\arguments{
\item{fit}{Fitted sparse VAR, VARX or VARMA model.}

\item{model}{Type of model that was estimated: VAR, VARX or VARMA.}

\item{h}{Desired forecast horizon.}
}
\value{
Vector of length k containing the h-step ahead forecasts for the k time series.
}
\description{
Function to obtain h-step ahead direct forecast based on estimated VAR, VARX or VARMA model
}
\examples{
data(Y)
VARfit <- sparseVAR(Y) # sparse VAR
VARforecast <- directforecast(fit=VARfit, model="VAR", h=1)
}
