% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed-mult-vec.R
\name{bed_prodVec}
\alias{bed_prodVec}
\title{Product with a vector}
\usage{
bed_prodVec(
  obj.bed,
  y.col,
  ind.row = rows_along(obj.bed),
  ind.col = cols_along(obj.bed),
  center = rep(0, length(ind.col)),
  scale = rep(1, length(ind.col)),
  ncores = 1
)
}
\arguments{
\item{obj.bed}{A \link{bed} object.}

\item{y.col}{A vector of same size as \code{ind.col}.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{center}{Vector of same length of \code{ind.col} to subtract from columns
of \code{X}.}

\item{scale}{Vector of same length of \code{ind.col} to divide from columns
of \code{X}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}
}
\value{
\eqn{X \cdot y}.
}
\description{
Product between a "bed" object and a vector.

Missing values are replaced by 0 (after centering), as if they
had been imputed using parameter \code{center}.
}
\examples{
bedfile <- system.file("extdata", "example.bed", package = "bigsnpr")
obj.bed <- bed(bedfile)

y.col <- rep(1, ncol(obj.bed))
str(bed_prodVec(obj.bed, y.col))

}
