% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{snp_fastImpute}
\alias{snp_fastImpute}
\title{Fast imputation}
\usage{
snp_fastImpute(Gna, infos.chr, alpha = 0.02, size = 500, p.train = 0.8,
  seed = NA, ncores = 1)
}
\arguments{
\item{Gna}{A \link[=FBM.code256-class]{FBM.code256}
(typically \code{<bigSNP>$genotypes}).\cr
You can have missing values in your data.}

\item{infos.chr}{Vector of integers specifying each SNP's chromosome.\cr
Typically \code{<bigSNP>$map$chromosome}.}

\item{alpha}{Type-I error for testing correlations. Default is \code{0.02}.}

\item{size}{Number of neighbor SNPs to be possibly included in the model
imputing this particular SNP. Default is \code{500}.}

\item{p.train}{Proportion of non missing genotypes that are used for training
the imputation model while the rest is used to assess the accuracy of
this imputation model. Default is \code{0.8}.}

\item{seed}{An integer, for reproducibility. Default doesn't use seeds.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}
}
\value{
A \code{data.frame} with
\itemize{
\item the proportion of missing values by SNP,
\item the estimated proportion of imputation errors by SNP.
}
}
\description{
Fast imputation algorithm based on local XGBoost models. \strong{This algorithm
has not been extensively compared with other imputation methods yet.}
}
