% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\name{get_dataset}
\alias{get_dataset}
\alias{exists_dataset}
\title{Gets an existing dataset in a project}
\usage{
get_dataset(project, dataset)

exists_dataset(project, dataset)
}
\arguments{
\item{project}{The project name, a string}

\item{dataset}{The dataset to get, a string}
}
\value{
a character vector of dataset names
}
\description{
Gets an existing dataset in a project

\code{exists_dataset} merely checks if a table exists, and returns
either \code{TRUE} or \code{FALSE}.
}
\examples{
\dontrun{
get_dataset("publicdata", "shakespeare")
}
}
\seealso{
Google API documentation:
\url{https://cloud.google.com/bigquery/docs/reference/v2/datasets/get}

Other datasets: \code{\link{delete_dataset}},
  \code{\link{insert_dataset}},
  \code{\link{list_datasets}}, \code{\link{update_dataset}}
}
