% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigpca.R
\name{select.least.assoc}
\alias{select.least.assoc}
\title{Select subset of rows least associated with a categorical variable}
\usage{
select.least.assoc(bigMat, keep = 0.05, phenotype = NULL, least = TRUE,
  dir = "", n.cores = 1, verbose = TRUE)
}
\arguments{
\item{bigMat}{a big.matrix object, or any argument accepted by get.big.matrix(), which includes
paths to description files or even a standard matrix object.}

\item{keep}{numeric, by default a proportion (decimal) of the original number of rows/columns to choose
for the subset. Otherwise if an integer>2 then will assume this is the size of the desired subset,
e.g, for a dataset with 10,000 rows where you want a subset size of 1,000 you could set 'keep' as
either 0.1 or 1000.}

\item{phenotype}{a vector which contains the categorical variable to perform an association 
test for phenotype, etc. This should be the same length as the number of columns (e.g, samples)
in bigMat.}

\item{least}{logical, whether to select TRUE, the top least associated variables, or FALSE, the most 
associated.}

\item{dir}{directory containing the filebacked.big.matrix, same as dir for get.big.matrix.}

\item{n.cores}{integer, if wanting to process the analysis using multiple cores, specify the number}

\item{verbose}{logical, whether to display additional output}
}
\value{
A set of row or column indexes (depents on 'rows' parameter) of the variables most dependent
 (or indepent) variables measured by association with a [continuous/categorical] phenotype.
}
\description{
Runs a quick association analysis on the dataset against a phenotype/categorical
variable stored in a dataframe, and uses the results as a way to select
a subset of the original matrix, so you may wish to select the 'N' least associated
variables, or the 'N' most associated.
}
\examples{
bmat <- generate.test.matrix(5,big.matrix=TRUE)
pheno <- rep(1,ncol(bmat)); pheno[which(runif(ncol(bmat))<.5)] <- 2
most.correl <- select.least.assoc(bmat,phenotype=pheno,least=FALSE)
least.correl <- select.least.assoc(bmat,phenotype=pheno,least=TRUE)
cor(bmat[least.correl,][1,],pheno)  # least correlated
cor(bmat[most.correl,][1,],pheno)  # most correlated
}
\seealso{
\code{\link{quick.pheno.assocs}}
}
\author{
Nicholas Cooper
}
