% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{get_within_networks}
\alias{get_within_networks}
\title{Obtain the within-block networks defined by the block attribute.}
\usage{
get_within_networks(network, block, combined_networks = TRUE)
}
\arguments{
\item{network}{a network object}

\item{block}{a vector of integers representing the block of each node}

\item{combined_networks}{a boolean indicating whether the between-block networks should be returned as a \code{combined_networks} object or not (default is TRUE)}
}
\value{
a list of networks
}
\description{
Function to return a list of networks, each network representing the within-block network of a block.
}
\examples{
# Load an embedded network object.
data(toyNet)
get_within_networks(toyNet, toyNet \%v\% "block")
}
