% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uci_go.R
\name{uci_go}
\alias{uci_go}
\title{Sending command go for chess engine}
\usage{
uci_go(engine, depth = NULL, infinite = FALSE, stoptime = 1,
  wtime = NULL, btime = NULL, winc = NULL, binc = NULL)
}
\arguments{
\item{engine}{engine object}

\item{depth}{integer depth (search x plies only)}

\item{infinite}{boolean default FALSE. If TRUE, stoptime (next argument) should be defined}

\item{stoptime}{integer default 1. Used in Sys.sleep after go infinite in egine. After this, uci_stop() is executed}

\item{wtime}{integer default NULL (white has x msec left on the clock)}

\item{btime}{integer default NULL (black has x msec left on the clock)}

\item{winc}{integer default NULL (white increment per move in mseconds if x > 0)}

\item{binc}{integer default NULL (black increment per move in mseconds if x > 0)}
}
\value{
engine object
}
\description{
Sending command go for chess engine. Info about go command from http://wbec-ridderkerk.nl/html/UCIProtocol.html
start calculating on the current position set up with the "position" command. There are a number of commands that can follow this command, all will be sent in the same string. If one command is not send its value should be interpreted as it would not influence the search.
}
\examples{
\donttest{
# Linux (make sure you have executable permission):
engine_path <- "./stockfish_10_x64"
# Windows
# engine_path <- "./stockfish_10_x64.exe"
e <- uci_engine(engine_path)
e <- uci_go(depth = 10)
uci_quit(e)
# Using pipe '\%>\%' from magrittr:
require(magrittr)
uci_engine(engine_path) \%>\% uci_go(depth = 10) \%>\% uci_quit()
# Find best answer for black after 1. e4 in 100 seconds:
uci_engine(engine_path) \%>\% uci_position(moves = "e2e4") \%>\%
  uci_go(depth = 20) \%>\% uci_quit() \%>\% uci_parse()
# Find best answer for black after 1. e4 in 100 seconds:
uci_engine(engine_path) \%>\% uci_position(moves = "e2e4") \%>\%
  uci_go(infinite = TRUE,stoptime = 100) \%>\% uci_quit() \%>\% uci_parse()}
}
