% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigscale.R
\name{bigscale}
\alias{bigscale}
\title{Construct Scaled Design Matrices for Big Survival Models}
\usage{
bigscale(
  formula = survival::Surv(time = time, status = status) ~ .,
  data,
  norm.method = "standardize",
  strata.size = 20,
  batch.size = 1,
  features.mean = NULL,
  features.sd = NULL,
  parallel.flag = FALSE,
  num.cores = NULL,
  bigmemory.flag = FALSE,
  num.rows.chunk = 1e+06,
  col.names = NULL,
  type = "short"
)
}
\arguments{
\item{formula}{formula used to extract the outcome and predictors that
should be included in the scaled design matrix.}

\item{data}{Input data source containing the variables referenced in
\code{formula}.}

\item{norm.method}{Normalisation strategy (for example centring or
standardising columns) applied to the feature matrix.}

\item{strata.size}{Number of observations to retain from each stratum when
constructing stratified batches.}

\item{batch.size}{Total size of each mini-batch produced by the scaling
routine.}

\item{features.mean}{Optional vector of column means that can be reused to
normalise multiple data sets in a consistent manner.}

\item{features.sd}{Optional vector of column standard deviations that pairs
with \code{features.mean} during scaling.}

\item{parallel.flag}{Logical flag signalling whether the scaling work should
be parallelised across cores.}

\item{num.cores}{Number of processor cores allocated when
\code{parallel.flag} is \code{TRUE}.}

\item{bigmemory.flag}{Logical flag specifying whether intermediate results
should be stored in \pkg{bigmemory}-backed matrices.}

\item{num.rows.chunk}{Chunk size used when streaming data from on-disk
objects into memory.}

\item{col.names}{Optional character vector assigning column names to the
generated design matrix.}

\item{type}{Type of model or preprocessing target being prepared, such as
survival or regression.}
}
\value{
A scaled design matrix of the scaler class along with metadata describing
the transformation that was applied.
time.indices: indices of the time variable
cens.indices: indices of the censored variables
features.indices: indices of the features
time.sd: standard deviation of the time variable
time.mean: mean of the time variable
features.sd: standard deviation of the features
features.mean: mean of the features
nr: number of rows
nc: number of columns
col.names: columns names
}
\description{
Prepares a large-scale feature matrix for stochastic gradient
descent byapplying optional normalisation, stratified sampling,
and batching rules.
}
\examples{
data(micro.censure, package = "bigPLScox")
surv_data <- stats::na.omit(
  micro.censure[, c("survyear", "DC", "sexe", "Agediag")]
)
scaled <- bigscale(
  survival::Surv(survyear, DC) ~ .,
  data = surv_data,
  norm.method = "standardize",
  batch.size = 16
)
 
}
\seealso{
\code{\link[=bigSurvSGD.na.omit]{bigSurvSGD.na.omit()}} for fitting models that use the scaled
features.
}
