% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_main.R
\name{bdm.ptsne}
\alias{bdm.ptsne}
\title{Parallelized t-SNE}
\usage{
bdm.ptsne(bdm, threads = 3, type = "SOCK", layers = 2, rounds = 1,
  boost = 2, whiten = 4, input.dim = NULL, ppx = 100, itr = 100,
  tol = 1e-05, alpha = 0.5, Y.init = NULL, info = 1)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{threads}{The number of parallel threads (in principle only limited by hardware resources, \code{i.e.} number of cores and available memory)}

\item{type}{The type of cluster: 'SOCK' (default) for intra-node parallelization, 'MPI' (\code{message passing interface}) for inter-node parallelization.}

\item{layers}{The number of layers (\code{minimum} 2, \code{maximum} the number of threads).}

\item{rounds}{The number of rounds (2 by default).}

\item{boost}{A running time accelerator factor. By default (\code{boost == 1}). See details.}

\item{whiten}{Preprocessing of raw data. If \code{whiten = 4} (default value) raw data is transformed to principal components (PCA) and whitened afterwards. If \code{whiten = 3} only PCA is performed with NO whitening. If \code{whiten = 2} raw data is only centered and scaled. If \code{whiten = 1} raw data is only centered. If \code{whiten = 0} no preprocessing is performed at all.}

\item{input.dim}{If raw data is given as (or is transformed to) principal components, \var{input.dim} sets the number of principal components to be used as input dimensions. Otherwise all data columns are used as input dimensions. By default \code{input.dim = ncol(bdm$data)}.}

\item{ppx}{The value of perplexity to compute similarities (100 by default).}

\item{itr}{The number of iterations for computing input similarities (100 by default).}

\item{tol}{The tolerance lower bound for computing input similarities (1e-05 by default).}

\item{alpha}{The momentum factor (0.5 by default).}

\item{Y.init}{A \code{nx2} matrix with initial mapping positions. By default (\code{NULL}) will use random initial positions)}

\item{info}{Progress output information: 1 yields inter-round results for progressive analytics, 0 disables intermediate results. Default value is 1.}
}
\value{
A copy of the input \var{bdm} instance with new element \var{bdm$ptsne} (t-SNE output).
}
\description{
Starts the ptSNE algorithm (first step of the mapping protocol).
}
\details{
By default the algorithm is structured in \eqn{\sqrt{n}} epochs of \eqn{\sqrt{z}} iterations each, where \var{n} is the dataset size and \var{z} is the thread-size (\eqn{z=n*layers/threads}). The running time of the algorithm is then determined by \eqn{epochs*iters*t_i+ epochs*t_e} where \var{t_{i}} is the running time of a single iteration and \var{t_{e}} is the inter-epoch running time.

The \var{boost} factor is meant to reduce the running time. With \eqn{boost > 1} the algorithm is structured in \eqn{n/boost} epochs with \eqn{z*boost} iterations each. This structure performs the same total number of iterations but arranged into a lower number of epochs, thus decreasing the total running time to \eqn{epochs*iters*t_i + 1/boost*epochs*t_e}. When the number of threads is high, the inter-epoch time can be high, in particular when using 'MPI' parallelization, thus, reducing the number of epochs can result in a significant reduction of the total running time. The counterpart is that increasing the number of iterations per epoch might result in a lack of convergence, thus the \var{boost} factor must be used with caution. To the most of our knowledge using values up to \eqn{boost=2.5} is generally safe.

In case of extremely large datasets, we strongly recommend to initialize the \var{bdm} instance with already preprocessed data and use \code{whiten = 0}. Fast principal components approximations can be computed by means of \var{e.g.} \code{flashpcaR} or \code{scater} R packages.
}
\examples{

# --- load example dataset
bdm.example()
# --- perform ptSNE
\dontrun{
exMap <- bdm.ptsne(exMap, threads = 10, layers = 2, rounds = 2, ppx = 200)
}
# --- plot the Cost function
bdm.cost(exMap)
# --- plot ptSNE output
bdm.ptsne.plot(exMap)
}
