% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_plot.R
\name{bdm.plot}
\alias{bdm.plot}
\title{Mapping plots (ptSNE, paKDE, WTT)}
\usage{
bdm.plot(bdm, ptsne = FALSE, ptsne.cex = 0.5, ptsne.bg = "#FFFFFF",
  ptsne.pltt = NULL, pakde.pltt = NULL, pakde.lvls = 16,
  wtt.lwd = 1, plot.peaks = T, labels.cex = 1, layer = 1)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()} or a list of them to make a comparative plot.}

\item{ptsne}{A logical value. By default (\code{ptsne = FALSE}) the function depicts the plot of the last downstream step of the protocol that has been computed. With \code{ptsne = TRUE} the function plots back the ptSNE output.}

\item{ptsne.cex}{The size of the mapped data-points in the ptSNE plot. Default value is \code{ptsne.cex = 0.5}.}

\item{ptsne.bg}{The background colour of the ptSNE plot. Default value is \code{ptsne.bg = #FFFFFF} (white).}

\item{ptsne.pltt}{A colour palette to show the clusters in the ptSNE plot by colouring the mapped data-points. By default (\code{ptsne.pltt = NULL}) the default palette is used.}

\item{pakde.pltt}{A colour palette to show levels in the paKDE plot. By default (\code{pakde.pltt = NULL}) the default palette is used.}

\item{pakde.lvls}{The number of levels of the density heat-map (16 by default).}

\item{wtt.lwd}{The width of the watertrack lines (as set in \code{par()}).}

\item{plot.peaks}{Logical value (TRUE by default). If set to TRUE and the up-stream step \code{bdm$wtt()} is computed marks the peak of each cluster.}

\item{labels.cex}{If \var{plot.peaks} is TRUE, the size of the labels of the clusters (as set in \code{par()}). By default \code{labels.cex=0.0} and the labels of the clusters are not depicted.}

\item{layer}{The number of a layer (1 by default).}
}
\value{
None.
}
\description{
Mapping plots (ptSNE, paKDE, WTT)
}
\examples{

bdm.example()
exMap <- bdm.plot(exMap)
}
