% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_main.R
\name{bdm.save}
\alias{bdm.save}
\title{Save \var{bdm} instance}
\usage{
bdm.save(...)
}
\arguments{
\item{...}{A \var{bdm} instance as generated by \code{bdm.init()}.}
}
\value{
None
}
\description{
Saves a \var{bdm} instance with default path/file names, as given by \code{bdm.mybdm()/bdm.fName(bdm)}. Default file name is generated based on \code{bdm$dSet} and ptSNE main parameters (threads, layers, rounds, perplexity).  The purpose of functions \code{bdm.save()} and \code{bdm.scp()} used with \code{bdm.fName()} is to ease the task of working/organizing multiple runs on the same dataset.
}
\examples{

# --- get a matrix with raw-data
mydata <- cbind(rnorm(10000, mean = 0, sd = 3),  ncol = 2)
mylabels <- apply(mydata, 1, function(row) round(sqrt(sum(row**2)), 0))
# --- create a \\var{bdm} instance with our raw-data matrix
mybdm <- bdm.init('mydataset', mydata, labels = mylabels)
str(mybdm)
# --- save it
\dontrun{
bdm.save(mybdm)
}
}
