% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_main.R
\name{bdm.pakde}
\alias{bdm.pakde}
\title{Perplexity-adaptive kernel density estimation}
\usage{
bdm.pakde(bdm, layer = 1, threads = 2, type = "SOCK", ppx = 100,
  itr = 100, tol = 1e-05, g = 200, g.exp = 3)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{layer}{The number of the t-SNE layer (1 by default).}

\item{threads}{The number of parallel threads (in principle only limited by hardware resources, \code{i.e.} number of cores and available memory)}

\item{type}{The type of cluster: 'SOCK' (default) for intra-node parallelization, 'MPI' for inter-node parallelization (\code{message passing interface} parallel environment).}

\item{ppx}{The value of perplexity to compute similarities (100 by default).}

\item{itr}{The number of iterations for computing input similarities (100 by default).}

\item{tol}{The tolerance lower bound for computing input similarities (1e-05 by default).}

\item{g}{The resolution of the density space grid (\code{g*g} cells, 200 by default).}

\item{g.exp}{A numeric factor to avoid border effects. The grid limits will be expanded so as to enclose the density of the kernel of the most extreme mapped points up to \code{g.exp} times \eqn{\sigma}. By default, (\code{g.exp = 3}) the grid limits are expanded so as to enclose the 0.9986 of the probability mass of the most extreme kernels.}
}
\value{
A copy of the input \var{bdm} instance with new element \var{bdm$pakde} (paKDE output). \code{bdm$pakde[[layer]]$layer = 'NC'} stands for not computed layers.
}
\description{
Perplexity-adaptive kernel density estimation
}
\details{
When computing the \var{paKDE} the embedding area is discretized as a grid of size \code{g*g} cells. In order to avoid border effects, the limits of the grid are expanded by default so as to enclose at least the 0.9986 of the cumulative distribution function (\eqn{3 \sigma}) of the kernels of the most extreme mapped points in each direction.
The existence of outliers in the mapping can lead to undesired expansion of the grid limits. We can overcome this using lower values of \var{g.exp}. By setting \code{g.exp = 0} the grid limits will be equal to the range of the embedding.
Values of \var{g.exp = c(0, 1, 2, 3, 4, 5, 6)} enclose cdf values of \var{0, 0.8413, 0.9772, 0.9986, 0.99996, 0.99999, 1.0} respectively.
}
\examples{

# --- load mapped dataset
bdm.example()
# --- run paKDE
\dontrun{
exMap <- bdm.pakde(exMap, threads = 4, ppx = 200, g = 200, g.exp = 3)
}
# --- plot paKDE output
bdm.plot(exMap)
}
