% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcontmnorm.R
\name{rcontmnorm}
\alias{rcontmnorm}
\title{Contaminated Normal Generator}
\usage{
rcontmnorm(
  n,
  d = 2,
  mu1 = rep(0, d),
  sigma1 = diag(d),
  mu2 = rep(0, d),
  sigma2 = diag(d),
  g
)
}
\arguments{
\item{n}{sample size}

\item{d}{dimension. Defaults to 2 for bivariate normal errors.}

\item{mu1}{mean vector for first multivariate normal distribution. Defaults
to the zero vector.}

\item{sigma1}{variance-covariance matrix for first multivariate normal
distribution. Defaults to the d by d identity matrix, where d is the
dimension.}

\item{mu2}{mean vector for second multivariate normal distribution. Defaults
to the zero vector.}

\item{sigma2}{variance-covariance matrix for second multivariate normal
distribution. Defaults to the d by d identity matrix, where d is the
dimension.}

\item{g}{proportion of contamination. Defaults to zero producing
non-contaminated multivariate normal data.}
}
\value{
An \code{n} by \code{d} contaminated multivariate normal matrix.
}
\description{
This function generates contaminated multivariate normal errors that are used
in the generation of the Bifurcating autoregressive tree.
}
\examples{
#Non-contaminated bivariate normal:
rcontmnorm(10, sigma2=2^2*matrix(c(1,0,0,1),nrow=2) , g=0)
#Contaminated bivariate normal with 20\% contamination:
rcontmnorm(10, sigma2=2^2*matrix(c(1,0,0,1),nrow=2) , g=0.2)
}
