% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_bife.R
\name{predict.bife}
\alias{predict.bife}
\title{Computes Predicted Probabilities}
\usage{
\method{predict}{bife}(object, X_new = NULL, alpha_new = NULL,
  corrected = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{bife}.}

\item{X_new}{a regressor matrix for predictions. If not supplied predictions are based on the
matrix returned by the object \code{bife}. See \code{Details}.}

\item{alpha_new}{a scalar or vector of fixed effects. If not supplied predictions are based on the
vector of fixed effects returned by \code{bife}. See \code{Details}.}

\item{corrected}{an optional logical flag that specifies whether the predicted probabilities are
based on the bias-corrected/-adjusted parameters. Default is \code{TRUE} (bias-corrected).}

\item{...}{other arguments}
}
\value{
The function \code{predict.bife} returns a (named) vector of predicted probabilities.
}
\description{
Returns the predicted probabilities of an object returned by \code{bife}.
}
\details{
The regressor matrix returned by the object \code{bife} only includes individuals that 
were not dropped during fitting due to a non-varying response (perfect classification).
The predicted probabilities of those observations are equal to their response.

If \code{alpha_new} is supplied as a scalar each predicted probability is computed with
the same fixed effect. If \code{alpha_new} is supplied as a vector it has to be of same 
dimension as the corresponding regressor matrix.
}
\examples{
library("bife")

# Load 'psid' dataset
dataset <- psid
head(dataset)

# Fixed effects logit model w/o bias-correction
mod_no <- bife(LFP ~ AGE + I(INCH / 1000) + KID1 + KID2 + KID3 | ID, 
 data = dataset, bias_corr = "no")
 
# Compute predicted probabilities based on the regressor matrix
# and fixed effects stored in 'mod_no'
prob <- predict(mod_no)

# Compute predicted probabilities based on the regressor matrix
# and all fixed effects set to zero
prob_zero <- predict(mod_no, alpha_new = 0.0)

}
\seealso{
\code{\link{bife}}
}
\author{
Amrei Stammann, Daniel Czarnowske, Florian Heiss, Daniel McFadden
}
