% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class012-bids_uri.R
\name{BIDSURI}
\alias{BIDSURI}
\title{'BIDS' uniform resource indicator ('URI') class definition}
\usage{
BIDSURI(uri)
}
\arguments{
\item{uri}{'URI' string or another 'BIDS-URI' object}
}
\value{
A \code{BIDSURI} instance.
}
\description{
'BIDS' uniform resource indicator ('URI') class definition
}
\examples{

# basic properties
uri <- BIDSURI("bids::sub-01/fmap/sub-01_dir-AP_epi.nii.gz")
uri
uri$relative_path
uri$dataset_name

# set the entire uri
uri$format <- "bids:deriv1:sub-02/anat/sub-02_T1w.nii.gz"
uri

# resolve BIDS URI (partial support)


# resolving a BIDS URI requires dataset_description.json
dataset_description <- get_bids_dataset_description(
  parent_directory = "/path/to/BIDS/folder",
  Name = "A dummy experiments",
  BIDSVersion = "1.6.0",

  DatasetLinks = list(
    "deriv1" = "derivatives/derivative1",
    "phantoms" = "file:///data/phantoms"
  )
)

uri <- BIDSURI("bids::sub-01/fmap/sub-01_dir-AP_epi.nii.gz")
resolved <- resolve_bids_path(uri, dataset_description)

# resolved absolute path
print(resolved)

# `raw_resolution` is relative to the parent directory where
# `dataset_description.json` is stored
attr(resolved, "raw_resolution")

uri <- BIDSURI("bids:deriv1:sub-02/anat/sub-02_T1w.nii.gz")
resolved <- resolve_bids_path(uri, dataset_description)

print(resolved)

attr(resolved, "raw_resolution")


}
\author{
Zhengjia Wang
}
