% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_citation_matching.R
\name{convert_scopus_new_to_classic}
\alias{convert_scopus_new_to_classic}
\title{Convert new Scopus citation format to classic format}
\usage{
convert_scopus_new_to_classic(citation)
}
\arguments{
\item{citation}{Character string containing a bibliographic citation}
}
\value{
Character string with citation in classic Scopus format
}
\description{
Scopus has introduced a new citation format where the publication year appears
at the end in parentheses instead of after the title. This function converts
citations from the new format to the classic format by moving the year from
the end to after the title.
}
\details{
New Scopus format: AUTHOR, TITLE, JOURNAL, VOLUME, ISSUE, PAGES, (YEAR)
Classic Scopus format: AUTHOR, TITLE (YEAR) JOURNAL, VOLUME, PAGES

The function uses a robust approach:
\itemize{
  \item Extracts year from end (YYYY)
  \item Extracts first author from beginning
  \item Extracts pages (PP. xxx-xxx or PP. xxx)
  \item Extracts volume and issue numbers
  \item Extracts journal name (text before volume/issue/pages)
  \item Deduces title as remaining text after author
}
}
\keyword{internal}
