% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PriorFunctions.R
\name{setPriorParametersExNex}
\alias{setPriorParametersExNex}
\title{setPriorParametersExNex}
\usage{
setPriorParametersExNex(mu_mean, mu_sd, tau_scale, mu_j, tau_j, w_j)
}
\arguments{
\item{mu_mean}{A numeric for the mean of \eqn{\mu}}

\item{mu_sd}{A positive numeric for the standard deviation of \eqn{\mu}}

\item{tau_scale}{A positive numeric for the scale parameter of \eqn{\tau}}

\item{mu_j}{A vector of numerics for the means \eqn{\mu_j}}

\item{tau_j}{A vector of positive numerics for the standard deviations \eqn{\tau_j}}

\item{w_j}{A numeric in \verb{(0, 1)} for the weight of the Ex component}
}
\value{
A list with prior parameters of class \code{prior_parameters_list}
}
\description{
This function sets prior parameters for the analysis method \code{"exnex"}
for use in \code{\link[bhmbasket]{performAnalyses}}.
}
\details{
This function sets the prior parameters for the method proposed by Neuenschwander et al. (2016).
}
\examples{
 prior_parameters_exnex <- setPriorParametersExNex(0, 1, 2, c(4, 5), c(6, 7), 0.8)
}
\references{
Neuenschwander, Beat, et al. "Robust exchangeability designs
for early phase clinical trials with multiple strata."
\emph{Pharmaceutical statistics} 15.2 (2016): 123-134.
}
\seealso{
\code{\link[bhmbasket]{performAnalyses}}
\code{\link[bhmbasket]{getPriorParameters}}
\code{\link[bhmbasket]{combinePriorParameters}}
\code{\link[bhmbasket]{setPriorParametersBerry}}
\code{\link[bhmbasket]{setPriorParametersExNexAdj}}
\code{\link[bhmbasket]{setPriorParametersPooled}}
\code{\link[bhmbasket]{setPriorParametersStratified}}
\code{\link[bhmbasket]{getMuVar}}
}
\author{
Stephan Wojciekowski
}
