% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squeeze.R
\name{squeeze}
\alias{squeeze}
\alias{unsqueeze}
\title{Squeeze integers into a single string}
\usage{
squeeze(integers)

unsqueeze(strings, strict = FALSE)
}
\arguments{
\item{integers}{a numeric vector if integers.}

\item{strings}{a character vector of strings, preferably outputs of
\code{squeeze}.}

\item{strict}{a logical value, decides whether the output should be strictly
a list. If \code{FALSE} and the \code{strings} is a single string, the
function returns an atomic vector instead.}
}
\value{
\code{squeeze} returns a vector of characters, \code{unsqueeze}
  returns a list of numerics or a numeric vector.
}
\description{
This acts similar to \code{\link[base]{toString}} function, but it tries to
make the string as short as possible by squeezing sequences of integers into
boundary values only. Please see the examples section. \code{unsqueez}
reverses this operation.
}
\examples{
integers <- c(1, 3:5, NA, 27:38, 10:13, 9:11, 6)
squeeze(integers)

unsqueeze(squeeze(integers))
setdiff(na.omit(integers), unsqueeze(squeeze(integers)))

}
\author{
Jakub Bujnowicz \email{bujnowiczgithub@gmail.com}
}
