% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scree_type.R
\name{scree_type_ar}
\alias{scree_type_ar}
\title{Negative log AR likelihood values for scree-type plots}
\usage{
scree_type_ar(data, order.max, method = "yw")
}
\arguments{
\item{data}{numeric vector of data}

\item{order.max}{maximum autoregressive order to consider}

\item{method}{character string giving the method used to fit the model, to be forwarded to \code{stats::\link{ar}}}
}
\value{
a data frame containing the autoregressive orders \code{p} and the corresponding negative log likelihood values \code{nll}
}
\description{
(Approximate) negative maximum log-likelihood for for different autoregressive orders to produce scree-type plots.
}
\details{
By default, the maximum likelihood is approximated by the Yule-Walker method, due to numerical stabililty and computational speed. Further details can be found in the simulation study section in the referenced paper.
}
\examples{
\dontrun{

###
### Interactive visual inspection for the sunspot data
###

data <- sqrt(as.numeric(sunspot.year))
data <- data <- data - mean(data)

screeType <- scree_type_ar(data, order.max=15)

# Determine the autoregressive order by an interactive visual inspection of the scree-type plot
plot(x=screeType$p, y=screeType$nll, type="b")
p_ind <- identify(x=screeType$p, y=screeType$nll, n=1, labels=screeType$p)
print(screeType$p[p_ind])
}
}
\references{
C. Kirch et al. (2018)
\emph{Beyond Whittle: Nonparametric Correction of a Parametric Likelihood With a Focus on Bayesian Time Series Analysis}
Bayesian Analysis
<doi:10.1214/18-BA1126>
}
