% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuisance_models.R
\name{nuisanceModel_linearTrend}
\alias{nuisanceModel_linearTrend}
\title{Normal linear trend model, with nuisance time series}
\usage{
nuisanceModel_linearTrend(mu.mu0 = 0, mu.sd = 10000, b.mu1 = 0,
  b.sd = 1, prop.scaling = 1)
}
\arguments{
\item{mu.mu0, mu.sd}{A priori mean and standard deviation of mu}

\item{b.mu1, b.sd}{A priori mean and standard deviation of b}

\item{prop.scaling}{Scaling parameter for generating Metropolis-Hastings
proposals of parameter of interest theta=c(mu,b)}
}
\value{
S3 \code{nuisanceModel} object representing the model parameter theta=c(mu,b)
of interest, containing the following fields:
  \item{theta_dim}{Dimension of parameter of interest (here: \code{theta_dim=2})}
  \item{excludeBoundary}{Logical; Should the outermost Fourier frequencies be 
  ignored in the frequency domain representation? (here: \code{excludeBoundary=F})}
  \item{get_noise}{Function taking the two arguments \code{data,theta} 
  to compute the nuisance/noise time series e_t from data and parameter 
  theta of interest. (here: e_t=data-mu-b*(1:n))}
  \item{propose_next_theta}{Function taking the parameters \code{data} 
  (Numeric vector of input data), \code{f} (Numeric Vector of current 
  spectral density at the Fourier frequencies within the Gibbs sampling algorithm) 
  and \code{previous_theta} (Previously sampled value of c(mu,b)) and 
  returning a new proposal value for c(mu,b)}
  \item{initialize_theta}{Function taking the Numeric Vector \code{data} of input
  data as argument to generate an initial value for c(mu,b) to start an MCMC
  algorithm}
  \item{lprior_theta}{Function; Log density of prior of theta}
}
\description{
This class represents the linear trend model X_t=bt + mu + e_t, t=1,...,n,
with intercept mu~N(mu.mu0,mu.sd^2) and slope b~N(b.mu1,b.sd^2)
and e_t being a nuisance parameter time series.
}
\details{
The parameters mu and b are assumed to be a priori independent.
The returned object of this function is intended for usage within
\link[beyondWhittle]{gibbs_AR_nuisance}, \link[beyondWhittle]{gibbs_NP_nuisance}
and \link[beyondWhittle]{gibbs_NPC_nuisance}.
The method \code{propose_next_theta} is optimized to be close to the
marginal joint posterior of (mu,b) in the model.
The proposal scaling can be controlled with the parameter \code{prop.scaling},
where larger values yield a broader (smaller values yield narrower) 
proposal distribution.
}
\keyword{internal}
