% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{writePosteriorModeScaffoldTypes}
\alias{writePosteriorModeScaffoldTypes}
\title{Write a file with the posterior mode for each scaffold type}
\usage{
writePosteriorModeScaffoldTypes(object, file, threshold_certainty = 0.9)
}
\arguments{
\item{object}{A bexy object.}

\item{file}{The name of the output file.}

\item{threshold_certainty}{The threshold for certainty on the posterior probabilities. All scaffolds that have a posterior probability less than this threshold are classified as 'uncertain'.}
}
\value{
No return value, called for side effects.
}
\description{
Write a file with the posterior mode for each scaffold type
}
\examples{
bex <- bexy()
tf <- tempfile(fileext = ".txt")
writePosteriorModeScaffoldTypes(bex, tf)
}
\seealso{
\code{\link{bexy}}
}
