% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bes_m_cushman.R
\name{bes_m_cushman}
\alias{bes_m_cushman}
\title{Configurational entropy for landscape mosaics}
\usage{
bes_m_cushman(x, nr_of_permutations, independent = FALSE)
}
\arguments{
\item{x}{SpatRaster, stars, RasterLayer, RasterStack, RasterBrick, matrix, or array containing one or more categorical rasters}

\item{nr_of_permutations}{Number of permutations performed on each input raster to calculate
possible distribution of total edge values}

\item{independent}{Should an independent set of permutations be performed for each input raster?
\code{TRUE}/\code{FALSE}.
Use \code{FALSE} (default) when each of your input rasters has the same configuration (proportion of categories).}
}
\value{
A tibble
}
\description{
Calculates Cushman's configurational entropy for landscape mosaics (2015)
}
\examples{
library(terra)
library(bespatial)
mosaic = rast(system.file("raster/mosaic.tif", package = "bespatial"))
ce1 = bes_m_cushman(mosaic, 1000)
plot(mosaic, main = round(ce1$value, 2))
bes_m_cushman(mosaic, 1000, independent = TRUE)
}
\references{
Cushman, S. A. (2015). Calculating the configurational entropy of a landscape mosaic. In Landscape Ecology (Vol. 31, Issue 3, pp. 481–489). Springer Science and Business Media LLC. https://doi.org/10.1007/s10980-015-0305-2
}
