% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distance}
\alias{distance}
\title{Distance between points}
\usage{
distance(x, y, xref, yref, along = FALSE)
}
\arguments{
\item{x}{vector with x-coordinate(s) of point(s)}

\item{y}{ditto for y}

\item{xref}{single x coordinate of reference point}

\item{yref}{ditto for y}

\item{along}{Logical: Should distances be computed along vector \code{(x,y)}?
If TRUE, \code{(xref,yref)} are ignored.
If both \code{(xref,yref)} are not given, along is set to TRUE.}
}
\value{
vector with the distances
}
\description{
Calculate distance between points on planar surface
}
\details{
The function is quite simple: \code{sqrt((xref - x)^2 + (yref - y)^2)}
}
\examples{

A <- c(3,  9,-1)
B <- c(7, -2, 4)
plot(A,B)
text(A,B, paste0("P",1:3), adj=1.1)
points(3,5, col=2, pch=16)
segments(3,5, A,B)
distance(A,B, 3,5)
text(c(3.2,6,1), c(6,1,4), round(distance(A,B, 3,5),2) )

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, 2012
}
\seealso{
\code{\link[spatstat]{nndist}} in the package \code{spatstat} for distance to nearest neighbour
}
\keyword{spatial}

