% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{confint.zibellreg}
\alias{confint.zibellreg}
\title{Confidence intervals for the regression coefficients}
\usage{
\method{confint}{zibellreg}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{an object of the class zibellreg}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required}

\item{...}{further arguments passed to or from other methods}
}
\value{
100(1-alpha)\% confidence intervals for the regression coefficients
}
\description{
Confidence intervals for the regression coefficients
}
\examples{
\donttest{
data(cells)
fit <- zibellreg(cells ~ smoker+gender|smoker+gender, data = cells, approach = "mle")
confint(fit)
}

}
