% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boltzmann.R
\name{get_boltzmann}
\alias{get_boltzmann}
\alias{get_boltzmann.default}
\alias{get_boltzmann.array}
\alias{get_boltzmann.RasterLayer}
\alias{get_boltzmann.RasterStack}
\alias{get_boltzmann.RasterBrick}
\title{Boltzmann entropy of a landscape gradient}
\usage{
get_boltzmann(x, base = "log10", relative = FALSE)

\method{get_boltzmann}{default}(x, base = "log10", relative = FALSE)

\method{get_boltzmann}{array}(x, base = "log10", relative = FALSE)

\method{get_boltzmann}{RasterLayer}(x, base = "log10", relative = FALSE)

\method{get_boltzmann}{RasterStack}(x, base = "log10", relative = FALSE)

\method{get_boltzmann}{RasterBrick}(x, base = "log10", relative = FALSE)
}
\arguments{
\item{x}{RasterLayer, RasterStack, RasterBrick, matrix, or array}

\item{base}{A logarithm base ("log", "log2" or "log10")}

\item{relative}{TRUE/FALSE}
}
\value{
a numeric vector
}
\description{
Calculates the Boltzmann entropy of a landscape gradient
}
\details{
The method for computing the Boltzmann entropy of a landscape
gradient works on integer values that are either positive or equals to zero.
This function automatically rounds values to the nearest integer value
(rounding halfway cases away from zero) and negative values are shifted to
positive values.
}
\examples{
new_c = c(56, 86, 98, 50, 45, 56, 96, 25,
          15, 55, 85, 69, 12, 52, 25, 56,
          32, 25, 68, 98, 58, 66, 56, 58)

lg = matrix(new_c, nrow = 3, ncol = 8, byrow = TRUE)
get_boltzmann(lg, relative = FALSE, base = "log10")
get_boltzmann(lg, relative = TRUE, base = "log2")
get_boltzmann(lg, relative = TRUE, base = "log")

}
\references{
Gao, Peichao, Hong Zhang, and Zhilin Li. "A hierarchy-based
solution to calculate the configurational entropy of landscape gradients."
Landscape Ecology 32.6 (2017): 1133-1146.

Gao, Peichao, Hong Zhang, and Zhilin Li. "An efficient
analytical method for computing the Boltzmann entropy of a landscape
gradient." Transactions in GIS (2018).
}
